REM  This converts all PNG files in the current folder  (in alphabetical order)  into a sprite-sheet that my RPG Maker can use
REM  It's assumed that all frames portray a character facing right
REM  The output will include both a right-facing and left-facing version of the animation
REM  PNG32:  ensures that photoshop can read the file correctly. Without this, ImageMagick may create a 256-color PNG with alpha which Photoshop cannot read correctly.
REM  Temp files:  _files.txt  _right.png  _left.png  (these will get deleted automatically)
REM  Result:  output.png


REM  delete previous output
del output.png

REM  Save a list of image files to use
dir /b *.png > _files.txt

REM  Generate "right.png"
convert @_files.txt +append PNG32:_right.png

REM  Generate "left.png"
convert @_files.txt -flop +append PNG32:_left.png

REM  Stack _right.png on top of _left.png
convert _right.png -append _left.png -append PNG32:output.png

REM  remove temporary files
del _files.txt
del _right.png
del _left.png
